# Copyright 2009 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

{
  'variables': {
    'serf_root': '<(DEPTH)/third_party/serf',
    'serf_src': '<(serf_root)/src',
  },
  'targets': [
    {
      'target_name': 'serf',
      'type': '<(library)',
      'dependencies': [
        '<(DEPTH)/third_party/apr/apr.gyp:include',
        '<(DEPTH)/third_party/aprutil/aprutil.gyp:include',
        # Comment out the reference to openssl to disable HTTPS fetching via
        # serf.  Also comment out the reference to openssl in src/DEPS.
        #
        # TODO(jmarantz): create an easy way to choose this option from the
        # 'gclient' command, without having to edit the gyp & DEPS files.
        #
        '<(DEPTH)/third_party/serf/select_openssl.gyp:select_openssl',
        '<(DEPTH)/third_party/zlib/zlib.gyp:zlib',
      ],
      'sources': [
        # This is a mixture of original serf sources (in serf_src)
        # and our patched versions in serf_root
        '<(serf_src)/auth/auth.c',
        '<(serf_src)/auth/auth_basic.c',
        '<(serf_src)/auth/auth_digest.c',
        '<(serf_src)/auth/auth_spnego.c',
        '<(serf_src)/auth/auth_spnego_sspi.c',
        '<(serf_src)/auth/auth_spnego_gss.c',
        '<(serf_src)/buckets/aggregate_buckets.c',
        '<(serf_src)/buckets/allocator.c',
        '<(serf_src)/buckets/barrier_buckets.c',
        '<(serf_src)/buckets/chunk_buckets.c',
        '<(serf_src)/buckets/dechunk_buckets.c',
        '<(serf_src)/buckets/deflate_buckets.c',
        '<(serf_src)/buckets/file_buckets.c',
        '<(serf_src)/buckets/headers_buckets.c',
        '<(serf_src)/buckets/iovec_buckets.c',
        '<(serf_src)/buckets/limit_buckets.c',
        '<(serf_src)/buckets/mmap_buckets.c',
        '<(serf_src)/buckets/request_buckets.c',
        '<(serf_src)/buckets/response_body_buckets.c',
        '<(serf_src)/buckets/simple_buckets.c',
        '<(serf_src)/buckets/socket_buckets.c',
        '<(serf_src)/context.c',
        '<(serf_src)/incoming.c',
        '<(serf_src)/ssltunnel.c',
        '<(serf_root)/instaweb_buckets.c',
        '<(serf_root)/instaweb_bwtp_buckets.c',
        '<(serf_root)/instaweb_outgoing.c',
        '<(serf_root)/instaweb_response_buckets.c',
        '<(serf_root)/instaweb_ssl_buckets.c',
        # If we ever want to support authentication, the following changes will
        # need to be made:
        # 1) Update aprutil.gyp to provide some more files (md5, uuid, etc. ---
        #    the link errors will be your guide).
        # 2) Re-enable call to serf__handle_auth_response in handle_response in
        #    instaweb_outgoing.c.
        # 3) Setup a callback via serf_config_credentials_callback to actually
        #    provide login info.
      ],
     'include_dirs': [
        '<(serf_src)',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '<(serf_src)',
        ],
      },
    }
  ],
}

