# Copyright 2011 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

{
  'variables': {
    'protobuf_java_srcroot': '<(DEPTH)/third_party/protobuf/java',
    'java_objroot': '<(DEPTH)/out/java',
    'protobuf_java_objroot': '<(java_objroot)/classes/protobuf',
    'protoc_out_dir': '<(SHARED_INTERMEDIATE_DIR)/protoc_out',
  },
  'targets': [
    {
      'target_name': 'protobuf_java_protoc',
      'suppress_wildcard': 1,
      'type': 'none',
      'sources': [
        '<(protobuf_java_srcroot)/descriptor/descriptor.proto',
      ],
      'rules': [
        {
          'rule_name': 'genproto',
          'extension': 'proto',
          'inputs': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
          ],
          'outputs': [
            '<(protoc_out_dir)/pagespeed/proto/com/google/protobuf/DescriptorProtos.java',
          ],
          'action': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
            '--proto_path=<(protobuf_java_srcroot)/descriptor',
            '<(protobuf_java_srcroot)/descriptor/descriptor.proto',
            '--java_out=<(protoc_out_dir)/pagespeed/proto',
          ],
          'message': 'Generating Java code from <(RULE_INPUT_PATH)',
        },
      ],
      'dependencies': [
        '<(DEPTH)/<(protobuf_gyp_path):protobuf_lite',
        '<(DEPTH)/<(protobuf_gyp_path):protoc#host',
      ],
      'export_dependent_settings': [
        '<(DEPTH)/<(protobuf_gyp_path):protobuf_lite',
      ],
    },
    {
      'target_name': 'protobuf_java_javac',
      'suppress_wildcard': 1,
      'type': 'none',
      'dependencies': [
        'protobuf_java_protoc',
      ],
      'actions': [
        {
          'action_name': 'javac',
          'inputs': [
            '<(protoc_out_dir)/pagespeed/proto/com/google/protobuf/DescriptorProtos.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/AbstractMessage.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/AbstractMessageLite.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/BlockingRpcChannel.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/BlockingService.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/ByteString.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/CodedInputStream.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/CodedOutputStream.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/Descriptors.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/DynamicMessage.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/ExtensionRegistry.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/ExtensionRegistryLite.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/FieldSet.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/GeneratedMessage.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/GeneratedMessageLite.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/Internal.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/InvalidProtocolBufferException.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/Message.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/MessageLite.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/ProtocolMessageEnum.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/RpcCallback.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/RpcChannel.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/RpcController.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/RpcUtil.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/Service.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/ServiceException.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/TextFormat.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/UninitializedMessageException.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/UnknownFieldSet.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/WireFormat.java',
          ],
          'outputs': [
            '<(protobuf_java_objroot)/com/google/protobuf/DescriptorProtos.class',
            '<(protobuf_java_objroot)/com/google/protobuf/AbstractMessage.class',
            '<(protobuf_java_objroot)/com/google/protobuf/AbstractMessageLite.class',
            '<(protobuf_java_objroot)/com/google/protobuf/BlockingRpcChannel.class',
            '<(protobuf_java_objroot)/com/google/protobuf/BlockingService.class',
            '<(protobuf_java_objroot)/com/google/protobuf/ByteString.class',
            '<(protobuf_java_objroot)/com/google/protobuf/CodedInputStream.class',
            '<(protobuf_java_objroot)/com/google/protobuf/CodedOutputStream.class',
            '<(protobuf_java_objroot)/com/google/protobuf/Descriptors.class',
            '<(protobuf_java_objroot)/com/google/protobuf/DynamicMessage.class',
            '<(protobuf_java_objroot)/com/google/protobuf/ExtensionRegistry.class',
            '<(protobuf_java_objroot)/com/google/protobuf/ExtensionRegistryLite.class',
            '<(protobuf_java_objroot)/com/google/protobuf/FieldSet.class',
            '<(protobuf_java_objroot)/com/google/protobuf/GeneratedMessage.class',
            '<(protobuf_java_objroot)/com/google/protobuf/GeneratedMessageLite.class',
            '<(protobuf_java_objroot)/com/google/protobuf/Internal.class',
            '<(protobuf_java_objroot)/com/google/protobuf/InvalidProtocolBufferException.class',
            '<(protobuf_java_objroot)/com/google/protobuf/Message.class',
            '<(protobuf_java_objroot)/com/google/protobuf/MessageLite.class',
            '<(protobuf_java_objroot)/com/google/protobuf/ProtocolMessageEnum.class',
            '<(protobuf_java_objroot)/com/google/protobuf/RpcCallback.class',
            '<(protobuf_java_objroot)/com/google/protobuf/RpcChannel.class',
            '<(protobuf_java_objroot)/com/google/protobuf/RpcController.class',
            '<(protobuf_java_objroot)/com/google/protobuf/RpcUtil.class',
            '<(protobuf_java_objroot)/com/google/protobuf/Service.class',
            '<(protobuf_java_objroot)/com/google/protobuf/ServiceException.class',
            '<(protobuf_java_objroot)/com/google/protobuf/TextFormat.class',
            '<(protobuf_java_objroot)/com/google/protobuf/UninitializedMessageException.class',
            '<(protobuf_java_objroot)/com/google/protobuf/UnknownFieldSet.class',
            '<(protobuf_java_objroot)/com/google/protobuf/WireFormat.class',
          ],
	  # Assumes javac is in the classpath.
          'action': [
            'javac',
            '-d', '<(protobuf_java_objroot)',
            '<(protoc_out_dir)/pagespeed/proto/com/google/protobuf/DescriptorProtos.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/AbstractMessage.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/AbstractMessageLite.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/BlockingRpcChannel.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/BlockingService.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/ByteString.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/CodedInputStream.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/CodedOutputStream.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/Descriptors.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/DynamicMessage.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/ExtensionRegistry.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/ExtensionRegistryLite.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/FieldSet.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/GeneratedMessage.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/GeneratedMessageLite.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/Internal.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/InvalidProtocolBufferException.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/Message.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/MessageLite.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/ProtocolMessageEnum.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/RpcCallback.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/RpcChannel.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/RpcController.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/RpcUtil.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/Service.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/ServiceException.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/TextFormat.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/UninitializedMessageException.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/UnknownFieldSet.java',
            '<(protobuf_java_srcroot)/com/google/protobuf/WireFormat.java',
          ],
        },
      ],
    },
    {
      'target_name': 'protobuf_java_jar',
      'suppress_wildcard': 1,
      'type': 'none',
      'dependencies': [
        'protobuf_java_javac',
      ],
      'actions': [
        {
          'action_name': 'jar',
          'inputs': [
            '<(protobuf_java_objroot)/com/google/protobuf/DescriptorProtos.class',
            '<(protobuf_java_objroot)/com/google/protobuf/AbstractMessage.class',
            '<(protobuf_java_objroot)/com/google/protobuf/AbstractMessageLite.class',
            '<(protobuf_java_objroot)/com/google/protobuf/BlockingRpcChannel.class',
            '<(protobuf_java_objroot)/com/google/protobuf/BlockingService.class',
            '<(protobuf_java_objroot)/com/google/protobuf/ByteString.class',
            '<(protobuf_java_objroot)/com/google/protobuf/CodedInputStream.class',
            '<(protobuf_java_objroot)/com/google/protobuf/CodedOutputStream.class',
            '<(protobuf_java_objroot)/com/google/protobuf/Descriptors.class',
            '<(protobuf_java_objroot)/com/google/protobuf/DynamicMessage.class',
            '<(protobuf_java_objroot)/com/google/protobuf/ExtensionRegistry.class',
            '<(protobuf_java_objroot)/com/google/protobuf/ExtensionRegistryLite.class',
            '<(protobuf_java_objroot)/com/google/protobuf/FieldSet.class',
            '<(protobuf_java_objroot)/com/google/protobuf/GeneratedMessage.class',
            '<(protobuf_java_objroot)/com/google/protobuf/GeneratedMessageLite.class',
            '<(protobuf_java_objroot)/com/google/protobuf/Internal.class',
            '<(protobuf_java_objroot)/com/google/protobuf/InvalidProtocolBufferException.class',
            '<(protobuf_java_objroot)/com/google/protobuf/Message.class',
            '<(protobuf_java_objroot)/com/google/protobuf/MessageLite.class',
            '<(protobuf_java_objroot)/com/google/protobuf/ProtocolMessageEnum.class',
            '<(protobuf_java_objroot)/com/google/protobuf/RpcCallback.class',
            '<(protobuf_java_objroot)/com/google/protobuf/RpcChannel.class',
            '<(protobuf_java_objroot)/com/google/protobuf/RpcController.class',
            '<(protobuf_java_objroot)/com/google/protobuf/RpcUtil.class',
            '<(protobuf_java_objroot)/com/google/protobuf/Service.class',
            '<(protobuf_java_objroot)/com/google/protobuf/ServiceException.class',
            '<(protobuf_java_objroot)/com/google/protobuf/TextFormat.class',
            '<(protobuf_java_objroot)/com/google/protobuf/UninitializedMessageException.class',
            '<(protobuf_java_objroot)/com/google/protobuf/UnknownFieldSet.class',
            '<(protobuf_java_objroot)/com/google/protobuf/WireFormat.class',
          ],
          'outputs': [
            '<(java_objroot)/protobuf.jar',
          ],
          'action': [
            'jar', 'cf', '<(java_objroot)/protobuf.jar',
            '-C', '<(protobuf_java_objroot)', '.'
	  ],
        },
      ],
    },
  ],
}
